/******************************************************************************\
**
**     COMPANY:	LDW Software
**
**      MODULE:	AnimManager
**
** DESCRIPTION:	Manages a set of animation sequences
**
**      AUTHOR:	Adrian Francis
**
\******************************************************************************/

#ifndef ANIM_MANAGER_H
#define ANIM_MANAGER_H

/******************************************************************************\
** LIBRARY INCLUDES
\******************************************************************************/
#include "../Game/Isola.h"	//TODO: EDirection - move here?

/******************************************************************************\
** CONSTANT DEFINITIONS
\******************************************************************************/
const int AnimManager_c_iMaxFrames = 16;

/******************************************************************************\
** CLASS ENUMERATIONS
\******************************************************************************/
enum EAnim
{
	eAnim_None = -1,

	eAnim_Bend,
	eAnim_Cheer,
	eAnim_Climb,
	eAnim_Dance,
	eAnim_Dive,
	eAnim_Embrace,
	eAnim_Exorcist,
	eAnim_Joy_Twirl_CW,
	eAnim_Jump,
	eAnim_Twirl_CCW,
	eAnim_Twirl_CW,
	eAnim_Disco,
	eAnim_DoTheMonkey,
	eAnim_Revel,
	eAnim_LieDown,
	eAnim_Scrub,
	eAnim_ShakeHead,
	eAnim_SwimOnBack,
	eAnim_Walk,
	eAnim_Work,
	eAnim_Pushups,

	eAnim_NumberOf
};

enum EAnimEffect
{
	eAnimEffect_OneShot,
	eAnimEffect_Loop,
	eAnimEffect_Bounce
};

enum EAnimFrame
{
	eAnimFrame_None = -1,
	eAnimFrame_RandomWalk = -2,

	eAnimFrame_Bend1 = 0,
	eAnimFrame_Bend2,
	eAnimFrame_Bend3,
	eAnimFrame_Bend4,
	eAnimFrame_Work1,
	eAnimFrame_Work2,
	eAnimFrame_Work3,
	eAnimFrame_Work4,
	eAnimFrame_Sit,
	eAnimFrame_Lie,
	eAnimFrame_PointNE,
	eAnimFrame_PointSE,
	eAnimFrame_PointSW,
	eAnimFrame_PointNW,
	eAnimFrame_ReachS,
	eAnimFrame_ReachN,
	eAnimFrame_Watch,

	eAnimFrame_Walk1,
	eAnimFrame_Walk2,
	eAnimFrame_Walk3,
	eAnimFrame_Walk4,
	eAnimFrame_Walk5,
	eAnimFrame_Walk6,
	eAnimFrame_Walk7,
	eAnimFrame_Walk8,

	eAnimFrame_NumberOf
};

enum EHeadDirection
{
	eHeadDirection_None = -1,
	eHeadDirection_Random = -2,
	eHeadDirection_RandomUpward = -3,

	eHeadDirection_Northeast = 0,
	eHeadDirection_Southeast,
	eHeadDirection_Southwest,
	eHeadDirection_Northwest,
	
	eHeadDirection_SouthSoutheast,
	eHeadDirection_South,
	eHeadDirection_SouthSouthwest,

	eHeadDirection_Up,
	eHeadDirection_NumberOf
};

/******************************************************************************\
** CLASS DEFINITIONS
\******************************************************************************/
class CAnimManager
{
private:

	//class structures
	struct SFrame
	{
		EAnimFrame		m_eAnimFrame;
		EHeadDirection	m_eHeadDirection;
		EDirection		m_eDirection;
	};

	struct SAnim
	{
		SFrame			m_sFrame[AnimManager_c_iMaxFrames];
		int				m_iNumFrames;

		float			m_fSpeed;
		EAnimEffect		m_eAnimEffect;

		//structure methods
		//process
		public:		void Initialize(const EAnimEffect eAnimEffect, const float fSpeed = 1.0f);
		public:		void AddFrame(const EAnimFrame eAnimFrame, const EHeadDirection eHeadDirection, const EDirection eDirection);
	};

	//class data
	SAnim		m_sAnim[eAnim_NumberOf];

	//class methods
	//setup
	public:		CAnimManager();

	//process

	//access
	public:		void GetFrame(const EAnim eAnim, const int iTime, const bool bForceUpdate, const bool bIsReversed, EAnimFrame &eAnimFrame, EHeadDirection &eHeadDirection, EDirection &eDirection) const;
	public:		const float GetSpeed(const EAnim eAnim) const;

	public:		const EAnimFrame RandomWalkFrame() const;

	public:		const EHeadDirection RandomHeadDirection(const EDirection eDirection, const bool bIncludeUp = false) const;
	private:	const EHeadDirection RandomNorthHeadDirection() const;
	private:	const EHeadDirection RandomEastHeadDirection() const;
	private:	const EHeadDirection RandomSouthHeadDirection() const;
	private:	const EHeadDirection RandomWestHeadDirection() const;

	public:		const EDirection RandomDirection() const;
	public:		const bool IsValidHeadDirection(const EHeadDirection eHeadDirection, const EDirection eDirection) const;
};

/******************************************************************************\
** GLOBAL DECLARATIONS
\******************************************************************************/
extern CAnimManager		AnimManager;

#endif

/******************************************************************************\
** END OF FILE
\******************************************************************************/